<?php
header('Content-Type: application/json');
require_once 'config.php';

$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    echo json_encode(['status' => 'error', 'message' => 'No data received']);
    exit;
}

try {
    $stmt = $pdo->prepare("INSERT INTO transaksi (
        ref_id, 
        store_name, 
        bank_name, 
        acc_number, 
        receiver_name, 
        amount, 
        admin_fee, 
        transaction_date
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->execute([
        $input['ref_id'] ?? '',
        $input['store_name'] ?? '',
        $input['bank_name'] ?? '',
        $input['acc_number'] ?? '',
        $input['receiver_name'] ?? '',
        $input['amount'] ?? 0,
        $input['admin_fee'] ?? 0,
        $input['transaction_date'] ?? date('Y-m-d H:i:s')
    ]);

    echo json_encode(['status' => 'success', 'message' => 'Transaction saved']);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>