<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
require_once 'config.php';

$device_id = $_GET['device_id'] ?? null;

if (!$device_id) {
    echo json_encode(['status' => 'error', 'message' => 'Device ID missing']);
    exit;
}

try {
    $stmt = $pdo->prepare("SELECT * FROM devices WHERE device_id = ?");
    $stmt->execute([$device_id]);
    $device = $stmt->fetch();

    if (!$device) {
        $insert = $pdo->prepare("INSERT INTO devices (device_id, daily_allowance, extra_credits, credits_used_today, last_reset_date, status) VALUES (?, 10, 0, 0, CURDATE(), 'aktif')");
        $insert->execute([$device_id]);
        
        $stmt->execute([$device_id]);
        $device = $stmt->fetch();
    }

    $today = date('Y-m-d');
    if ($device['last_reset_date'] !== $today) {
        $pdo->prepare("UPDATE devices SET credits_used_today = 0, last_reset_date = ? WHERE id = ?")
            ->execute([$today, $device['id']]);
        $device['credits_used_today'] = 0;
    }

    $total_allowance = (int)$device['daily_allowance'] + (int)$device['extra_credits'];
    $remaining = $total_allowance - (int)$device['credits_used_today'];

    echo json_encode([
        'status' => 'success',
        'device_id' => $device['device_id'],
        'remaining_credits' => $remaining < 0 ? 0 : $remaining,
        'used_today' => (int)$device['credits_used_today'],
        'total_quota' => $total_allowance
    ]);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>